 ; Ŀ
 ;   Xmark - mark all entities which have exdata.                          
 ;   Copyright 2002 by Rocket Software Ltd.                                
 ;   There is no truth to the rumour that Jim Morrison was assassinated    
 ;   by Microsoft, or that he was developing his own operating system.     
 ; 

 ; Ŀ
 ;   Ringo - another grdraw pattern maker.                                 
 ;   Arguments: Pa, the base point.                                        
 ;              Rad, the marker size.                                      
 ;              Colo, the marker colour.                                   
 ;   Calls Radi, returns nothing.                                          
 ; 
 (DEFUN RINGO (pa rad colo / )
  (radi pa (* rad 0.7) rad 45 (* pi 0.25) colo)
  (radi pa rad (* rad 2) 4 0 colo)
 (princ))
 ; Ŀ
 ;   Ringo end.                                                            
 ; 

 ; Ŀ
 ;   Alap - return a list of all applications having xdata attached to     
 ;   a given entity.                                                       
 ;   Takes one argument, an ename.                                         
 ;   Returns a list of strings.                                            
 ; 
 (DEFUN ALAP (enam / bb exdat sub applst)
  (setq bb (entget enam (list "*")))
  (if (setq exdat (assoc -3 bb))
      (progn
           (setq exdat (cdr exdat))
           (while (setq sub (car exdat))
                  (setq exdat (cdr exdat))
                  (setq applst (cons (car sub) applst)))))
 applst)
 ; Ŀ
 ;   Alap end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Radi - grdraw radial line set maker.                       
 ;   Does a complete circular set.                                         
 ;   Arguments: Pa, the base point.                                        
 ;              Rin, near end distance.                                    
 ;              Rout, far end distance.                                    
 ;              Reps, number of repetions in 360 degrees.                  
 ;              Stang, the start angle.                                    
 ;              Colo, the colour.                                          
 ;   Calls its mother, returns the empties.                                
 ;                                                                         
 ; 
 (DEFUN RADI (pa rin rout reps stang colo / pa1 pa2)
  (setq incr (/ pi (/ reps 2)))
  (repeat reps
          (setq pa1 (polar pa stang rin))
          (setq pa2 (polar pa stang rout))
          (grdraw pa1 pa2 colo)
          (setq stang (+ stang incr)))
 (princ))
 ; Ŀ
 ;   Radi end.                                                             
 ; 

 ; Ŀ
 ;   Xmark.                                                                
 ; 
 (DEFUN C:XMARK (/ rad ss num enam entt pa applst appnum siz malist app
                                                                  apasoc colo)
  (setq rad (/ (getvar "viewsize") 40))
 ; Ŀ
 ;   Get an ss of all entities with xdata.                                 
 ; 
  (if (setq ss (ssget "X" (list (list -3 (list "*")))))
      (progn
 ; Ŀ
 ;   Get an insertion and a lisp of apps for each one.                     
 ; 
           (setq num 0)
           (while (setq enam (ssname ss num))
                  (setq num (1+ num))
                  (if (= (cdr (assoc 0 (setq entt (entget enam)))) "POLYLINE")
                      (setq pa (cdr (assoc 10 (entget (entnext enam)))))
                      (setq pa (cdr (assoc 10 entt))))
                  (setq applst (alap enam))
 ; Ŀ
 ;   Place a marker on each entity with a specific colour and size for     
 ;   each different app having xdata attached to it.                       
 ; 
                  (setq appnum 0)
                  (setq siz rad)
                  (while (setq app (nth appnum applst))
                         (setq appnum (1+ appnum))
                         (if (setq apasoc (assoc app malist))
                             (setq colo (cadr apasoc))
                             (progn
                                  (setq colo (1+ (length malist)))
                                  (setq malist (cons (list app colo) malist))))
                         (ringo pa siz colo)
                         (setq siz (* siz (/ 1 0.7)))))))
 (princ))